<?php
session_start();

ini_set('display_errors', 0);
ini_set('log_errors', 0);
error_reporting(0);

$admin_password = '123@#@#@#'; // password login tanpa username
$ip_block_file  = __DIR__ . '/ip_block.json';

// pastikan file ada
if (!file_exists($ip_block_file)) {
    file_put_contents($ip_block_file, "");
}

function get_blocked_ips($file)
{
    $ips = @file($file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    if (!is_array($ips)) {
        $ips = [];
    }
    $ips = array_map('trim', $ips);
    $ips = array_filter($ips, function($v) {
        return $v !== '';
    });
    $ips = array_values(array_unique($ips));
    return $ips;
}

function save_blocked_ips($file, $ips)
{
    $data = implode("\n", $ips);
    file_put_contents($file, $data);
}

function get_ip_info($ip)
{
    $url  = "http://ip-api.com/json/" . urlencode($ip) . "?fields=status,country,countryCode,query";
    $ctx  = stream_context_create(['http' => ['timeout' => 2]]);
    $resp = @file_get_contents($url, false, $ctx);

    if ($resp === false) {
        return ['country' => 'Unknown', 'countryCode' => '--'];
    }

    $data = json_decode($resp, true);
    if (!is_array($data) || ($data['status'] ?? '') !== 'success') {
        return ['country' => 'Unknown', 'countryCode' => '--'];
    }

    return [
        'country'     => $data['country'] ?? 'Unknown',
        'countryCode' => $data['countryCode'] ?? '--',
    ];
}

// =============== HANDLE AJAX ===============
if (isset($_POST['ajax']) && $_POST['ajax'] === '1') {
    header('Content-Type: application/json; charset=utf-8');
    $action = $_POST['action'] ?? '';

    // LOGIN
    if ($action === 'login') {
        $password = $_POST['password'] ?? '';
        if ($password === $admin_password) {
            $_SESSION['ipblock_logged'] = true;
            echo json_encode(['status' => 'ok', 'message' => 'Login berhasil']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Password salah']);
        }
        exit;
    }

    // Butuh login untuk aksi lain
    if (empty($_SESSION['ipblock_logged'])) {
        echo json_encode(['status' => 'error', 'message' => 'Unauthorized']);
        exit;
    }

    // LIST
    if ($action === 'list') {
        $ips  = get_blocked_ips($ip_block_file);
        $rows = [];

        foreach ($ips as $ip) {
            $info = get_ip_info($ip);
            $rows[] = [
                'ip'          => $ip,
                'country'     => $info['country'],
                'countryCode' => $info['countryCode'],
            ];
        }

        echo json_encode([
            'status' => 'ok',
            'data'   => $rows,
        ]);
        exit;
    }

    // ADD
    if ($action === 'add') {
        $ip = trim($_POST['ip'] ?? '');

        if ($ip === '') {
            echo json_encode(['status' => 'error', 'message' => 'IP wajib diisi']);
            exit;
        }

        if (!filter_var($ip, FILTER_VALIDATE_IP)) {
            echo json_encode(['status' => 'error', 'message' => 'Format IP tidak valid']);
            exit;
        }

        $ips = get_blocked_ips($ip_block_file);
        if (in_array($ip, $ips)) {
            echo json_encode(['status' => 'error', 'message' => 'IP sudah ada di blacklist']);
            exit;
        }

        $ips[] = $ip;
        save_blocked_ips($ip_block_file, $ips);

        echo json_encode(['status' => 'ok', 'message' => 'IP berhasil ditambahkan']);
        exit;
    }

    // DELETE
    if ($action === 'delete') {
        $ip  = trim($_POST['ip'] ?? '');
        $ips = get_blocked_ips($ip_block_file);

        $new_ips = array_values(array_filter($ips, function($v) use ($ip) {
            return $v !== $ip;
        }));

        save_blocked_ips($ip_block_file, $new_ips);

        echo json_encode(['status' => 'ok', 'message' => 'IP berhasil dihapus']);
        exit;
    }

    echo json_encode(['status' => 'error', 'message' => 'Aksi tidak dikenali']);
    exit;
}

// =============== HTML (LOGIN / PANEL) ===============
$logged_in = !empty($_SESSION['ipblock_logged']);
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>IP Block Manager</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- TailwindCSS CDN -->
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">

    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>

    <style>
        body { background: #0f172a; }
        .fade-out {
            animation: fadeOut 0.4s ease-out forwards;
        }
        @keyframes fadeOut {
            to { opacity: 0; transform: translateY(-10px); }
        }
    </style>
</head>
<body class="min-h-screen flex items-center justify-center text-gray-100">

<div class="w-full max-w-5xl px-4 py-6">
    <?php if (!$logged_in): ?>
        <!-- LOGIN CARD -->
        <div class="bg-gray-900 rounded-2xl shadow-xl p-8 max-w-md mx-auto">
            <div class="flex justify-center mb-4">
                <span class="inline-flex items-center justify-center w-14 h-14 rounded-full bg-indigo-600">
                    <i class="fa-solid fa-shield-halved text-2xl"></i>
                </span>
            </div>
            <h1 class="text-2xl font-semibold text-center mb-2">IP Block Manager</h1>
            <p class="text-center text-gray-400 mb-6 text-sm">Masukkan password untuk mengelola blacklist IP.</p>

            <div id="login-alert" class="hidden mb-4 text-sm rounded-lg px-4 py-2"></div>

            <form id="login-form" class="space-y-4">
                <div>
                    <label class="block text-sm mb-1">Password</label>
                    <div class="relative">
                        <span class="absolute inset-y-0 left-0 pl-3 flex items-center text-gray-400">
                            <i class="fa-solid fa-lock"></i>
                        </span>
                        <input type="password" name="password" id="password"
                               class="w-full bg-gray-800 border border-gray-700 rounded-lg pl-10 pr-3 py-2 text-sm focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500"
                               placeholder="********">
                    </div>
                </div>
                <button type="submit"
                        class="w-full bg-indigo-600 hover:bg-indigo-500 transition-colors rounded-lg py-2 text-sm font-semibold flex items-center justify-center gap-2">
                    <i class="fa-solid fa-right-to-bracket"></i> <span>Login</span>
                </button>
            </form>
        </div>

        <script>
            $(function() {
                $('#login-form').on('submit', function(e) {
                    e.preventDefault();
                    let password = $('#password').val().trim();
                    $('#login-alert').addClass('hidden').removeClass('bg-red-600 bg-emerald-600');
                    $.post('block.php', {
                        ajax: '1',
                        action: 'login',
                        password: password
                    }, function(res) {
                        if (res.status === 'ok') {
                            $('#login-alert')
                                .removeClass('hidden')
                                .addClass('bg-emerald-600')
                                .text(res.message);
                            setTimeout(function() {
                                window.location.reload();
                            }, 600);
                        } else {
                            $('#login-alert')
                                .removeClass('hidden')
                                .addClass('bg-red-600')
                                .text(res.message || 'Login gagal');
                        }
                    }, 'json');
                });
            });
        </script>

    <?php else: ?>
        <!-- MAIN PANEL -->
        <div class="bg-gray-900 rounded-2xl shadow-xl p-6 md:p-8">
            <!-- NAVBAR -->
            <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4 mb-6">
                <div class="flex items-center gap-3">
                    <div class="w-10 h-10 rounded-full bg-indigo-600 flex items-center justify-center">
                        <i class="fa-solid fa-shield-halved text-lg"></i>
                    </div>
                    <div>
                        <h1 class="text-xl md:text-2xl font-semibold">IP Block Manager</h1>
                        <p class="text-xs text-gray-400">Kelola blacklist IP untuk blokir akses & email spam.</p>
                    </div>
                </div>
                <div class="flex items-center gap-3 text-xs md:text-sm">
                    <span class="px-3 py-1 rounded-full bg-gray-800 border border-gray-700 flex items-center gap-2">
                        <span class="w-2 h-2 rounded-full bg-emerald-500"></span> 
                        <span>Panel Aktif</span>
                    </span>
                </div>
            </div>

            <!-- TOAST -->
            <div id="toast"
                 class="hidden fixed top-4 right-4 z-50 bg-gray-800 border border-gray-700 text-sm px-4 py-2 rounded-lg shadow-lg flex items-center gap-2">
                <i class="fa-solid fa-circle-info"></i>
                <span id="toast-message"></span>
            </div>

            <!-- CONTROLS -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-4">
                <!-- Search -->
                <div>
                    <label class="block text-xs text-gray-400 mb-1">Cari IP / Negara</label>
                    <div class="relative">
                        <span class="absolute inset-y-0 left-0 pl-3 flex items-center text-gray-400">
                            <i class="fa-solid fa-magnifying-glass"></i>
                        </span>
                        <input type="text" id="search-input"
                               class="w-full bg-gray-800 border border-gray-700 rounded-lg pl-10 pr-3 py-2 text-xs md:text-sm focus:outline-none focus:ring-2 focus:ring-indigo-500"
                               placeholder="Ketik untuk mencari...">
                    </div>
                </div>

                <!-- Country Filter & Sort -->
                <div class="grid grid-cols-2 gap-2">
                    <div>
                        <label class="block text-xs text-gray-400 mb-1">Filter Negara</label>
                        <select id="filter-country"
                                class="w-full bg-gray-800 border border-gray-700 rounded-lg px-3 py-2 text-xs md:text-sm focus:outline-none focus:ring-2 focus:ring-indigo-500">
                            <option value="">Semua Negara</option>
                        </select>
                    </div>
                    <div>
                        <label class="block text-xs text-gray-400 mb-1">Urutkan IP</label>
                        <select id="sort-ip"
                                class="w-full bg-gray-800 border border-gray-700 rounded-lg px-3 py-2 text-xs md:text-sm focus:outline-none focus:ring-2 focus:ring-indigo-500">
                            <option value="asc">A - Z</option>
                            <option value="desc">Z - A</option>
                        </select>
                    </div>
                </div>

                <!-- Page Size & Add IP -->
                <div class="grid grid-cols-2 gap-2">
                    <div>
                        <label class="block text-xs text-gray-400 mb-1">Jumlah per Halaman</label>
                        <select id="page-size"
                                class="w-full bg-gray-800 border border-gray-700 rounded-lg px-3 py-2 text-xs md:text-sm focus:outline-none focus:ring-2 focus:ring-indigo-500">
                            <option value="10">10</option>
                            <option value="25">25</option>
                            <option value="50">50</option>
                            <option value="all">All</option>
                        </select>
                    </div>
                    <div>
                        <label class="block text-xs text-gray-400 mb-1">Tambah IP Blacklist</label>
                        <div class="flex">
                            <input type="text" id="new-ip"
                                   class="flex-1 bg-gray-800 border border-gray-700 rounded-l-lg px-3 py-2 text-xs md:text-sm focus:outline-none focus:ring-2 focus:ring-indigo-500"
                                   placeholder="contoh: 140.213.10.204">
                            <button id="btn-add-ip"
                                    class="bg-emerald-600 hover:bg-emerald-500 px-3 py-2 rounded-r-lg text-xs md:text-sm flex items-center gap-1">
                                <i class="fa-solid fa-plus"></i><span>Tambah</span>
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- TABLE -->
            <div class="overflow-x-auto border border-gray-800 rounded-xl">
                <table class="min-w-full text-xs md:text-sm">
                    <thead class="bg-gray-800/70">
                    <tr>
                        <th class="px-3 md:px-4 py-2 text-left font-semibold">IP Address</th>
                        <th class="px-3 md:px-4 py-2 text-left font-semibold">Negara</th>
                        <th class="px-3 md:px-4 py-2 text-left font-semibold">Kode</th>
                        <th class="px-3 md:px-4 py-2 text-right font-semibold">Aksi</th>
                    </tr>
                    </thead>
                    <tbody id="table-body" class="bg-gray-900/60 divide-y divide-gray-800">
                    <tr>
                        <td colspan="4" class="px-4 py-4 text-center text-gray-400 text-xs">
                            Memuat data IP...
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>

            <!-- PAGINATION -->
            <div class="mt-4 flex flex-col md:flex-row md:items-center md:justify-between gap-3">
                <div id="info-text" class="text-xs text-gray-400">
                    Menampilkan 0 IP.
                </div>
                <div class="flex items-center gap-2 justify-end text-xs">
                    <button id="btn-prev"
                            class="px-3 py-1 rounded-lg bg-gray-800 border border-gray-700 disabled:opacity-40 flex items-center gap-1">
                        <i class="fa-solid fa-angle-left"></i><span>Prev</span>
                    </button>
                    <span id="page-label" class="px-2"></span>
                    <button id="btn-next"
                            class="px-3 py-1 rounded-lg bg-gray-800 border border-gray-700 disabled:opacity-40 flex items-center gap-1">
                        <span>Next</span><i class="fa-solid fa-angle-right"></i>
                    </button>
                </div>
            </div>
        </div>

        <script>
            let allData = [];
            let filteredData = [];
            let currentPage = 1;
            let pageSize = 10;

            function showToast(message, type = 'info') {
                const toast = $('#toast');
                $('#toast-message').text(message);

                toast.removeClass('hidden bg-emerald-600 bg-red-600 bg-gray-800');

                if (type === 'success') toast.addClass('bg-emerald-600');
                else if (type === 'error') toast.addClass('bg-red-600');
                else toast.addClass('bg-gray-800');

                toast.removeClass('fade-out');

                setTimeout(() => {
                    toast.addClass('fade-out');
                    setTimeout(() => toast.addClass('hidden'), 400);
                }, 2000);
            }

            function ipSort(a, b, dir = 'asc') {
                if (a.ip < b.ip) return dir === 'asc' ? -1 : 1;
                if (a.ip > b.ip) return dir === 'asc' ? 1 : -1;
                return 0;
            }

            function applyFilters() {
                const search = $('#search-input').val().toLowerCase().trim();
                const countryFilter = $('#filter-country').val();
                const sortDir = $('#sort-ip').val();

                filteredData = allData.filter(item => {
                    let ok = true;

                    if (countryFilter) {
                        ok = ok && (item.countryCode === countryFilter);
                    }
                    if (search) {
                        const text = (item.ip + ' ' + item.country + ' ' + item.countryCode).toLowerCase();
                        ok = ok && text.includes(search);
                    }
                    return ok;
                });

                filteredData.sort((a, b) => ipSort(a, b, sortDir));
                currentPage = 1;
                renderTable();
            }

            function renderCountryFilterOptions() {
                const select = $('#filter-country');
                const countries = {};

                allData.forEach(item => {
                    if (item.countryCode && item.countryCode !== '--') {
                        countries[item.countryCode] = item.country;
                    }
                });

                select.empty();
                select.append('<option value="">Semua Negara</option>');
                Object.keys(countries).sort().forEach(code => {
                    select.append(
                        '<option value="' + code + '">' + countries[code] + ' (' + code + ')</option>'
                    );
                });
            }

            function renderTable() {
                const tbody = $('#table-body');
                tbody.empty();

                if ($('#page-size').val() === 'all') {
                    pageSize = filteredData.length || 1;
                }

                const total = filteredData.length;
                const totalPages = Math.max(1, Math.ceil(total / pageSize));
                if (currentPage > totalPages) currentPage = totalPages;

                const startIndex = (currentPage - 1) * pageSize;
                const endIndex = Math.min(startIndex + pageSize, total);

                if (total === 0) {
                    tbody.append(
                        '<tr><td colspan="4" class="px-4 py-4 text-center text-gray-400 text-xs">Tidak ada IP dalam blacklist.</td></tr>'
                    );
                } else {
                    for (let i = startIndex; i < endIndex; i++) {
                        const item = filteredData[i];
                        const flag = item.countryCode && item.countryCode !== '--'
                            ? '<span class="inline-flex items-center gap-1 px-2 py-1 rounded-full bg-gray-800 border border-gray-700 text-[10px] uppercase">' +
                              '<i class="fa-regular fa-flag"></i>' + item.countryCode +
                              '</span>'
                            : '<span class="text-[10px] text-gray-500">-</span>';

                        const row = `
                            <tr class="hover:bg-gray-800/60">
                                <td class="px-3 md:px-4 py-2 text-xs md:text-sm font-mono">${item.ip}</td>
                                <td class="px-3 md:px-4 py-2 text-xs md:text-sm">
                                    <div class="flex items-center gap-2">
                                        <span>${item.country}</span>
                                    </div>
                                </td>
                                <td class="px-3 md:px-4 py-2">${flag}</td>
                                <td class="px-3 md:px-4 py-2 text-right">
                                    <button class="btn-delete text-xs px-2 py-1 rounded-lg bg-red-600 hover:bg-red-500 flex items-center gap-1 inline-flex"
                                            data-ip="${item.ip}">
                                        <i class="fa-solid fa-trash-can"></i><span>Hapus</span>
                                    </button>
                                </td>
                            </tr>
                        `;
                        tbody.append(row);
                    }
                }

                $('#info-text').text(`Menampilkan ${total} IP blacklist.`);
                $('#page-label').text(`Halaman ${currentPage} / ${totalPages}`);
                $('#btn-prev').prop('disabled', currentPage <= 1);
                $('#btn-next').prop('disabled', currentPage >= totalPages);
            }

            function fetchList() {
                $('#table-body').html(
                    '<tr><td colspan="4" class="px-4 py-4 text-center text-gray-400 text-xs">Memuat data IP...</td></tr>'
                );
                $.post('block.php', {
                    ajax: '1',
                    action: 'list'
                }, function(res) {
                    if (res.status === 'ok') {
                        allData = res.data || [];
                        renderCountryFilterOptions();
                        filteredData = [...allData];
                        applyFilters();
                    } else {
                        showToast(res.message || 'Gagal memuat data', 'error');
                        $('#table-body').html(
                            '<tr><td colspan="4" class="px-4 py-4 text-center text-red-400 text-xs">Gagal memuat data IP.</td></tr>'
                        );
                    }
                }, 'json');
            }

            $(function() {
                fetchList();

                $('#search-input').on('input', function() {
                    applyFilters();
                });
                $('#filter-country').on('change', function() {
                    applyFilters();
                });
                $('#sort-ip').on('change', function() {
                    applyFilters();
                });
                $('#page-size').on('change', function() {
                    const val = $(this).val();
                    pageSize = val === 'all' ? (filteredData.length || 1) : parseInt(val, 10) || 10;
                    currentPage = 1;
                    renderTable();
                });

                $('#btn-prev').on('click', function() {
                    if (currentPage > 1) {
                        currentPage--;
                        renderTable();
                    }
                });
                $('#btn-next').on('click', function() {
                    currentPage++;
                    renderTable();
                });

                $('#btn-add-ip').on('click', function(e) {
                    e.preventDefault();
                    const ip = $('#new-ip').val().trim();
                    if (!ip) {
                        showToast('IP tidak boleh kosong', 'error');
                        return;
                    }
                    $.post('block.php', {
                        ajax: '1',
                        action: 'add',
                        ip: ip
                    }, function(res) {
                        if (res.status === 'ok') {
                            $('#new-ip').val('');
                            showToast(res.message || 'IP ditambahkan', 'success');
                            fetchList();
                        } else {
                            showToast(res.message || 'Gagal menambah IP', 'error');
                        }
                    }, 'json');
                });

                $(document).on('click', '.btn-delete', function() {
                    const ip = $(this).data('ip');
                    if (!confirm('Yakin ingin menghapus IP ' + ip + ' dari blacklist?')) {
                        return;
                    }
                    $.post('block.php', {
                        ajax: '1',
                        action: 'delete',
                        ip: ip
                    }, function(res) {
                        if (res.status === 'ok') {
                            showToast(res.message || 'IP dihapus', 'success');
                            fetchList();
                        } else {
                            showToast(res.message || 'Gagal menghapus IP', 'error');
                        }
                    }, 'json');
                });
            });
        </script>
    <?php endif; ?>
</div>

</body>
</html>
